#!/usr/bin/perl
#
# BlueLava v0.4.3
# (c) 2001-2004  Ian Wilkinson (ian@sgtwilko.f9.co.uk)
# (c) 1999  Bruce Locke  (blocke@shivan.org)
#
# Released under the GPL v2... see COPYING for details
# This software comes without any warranty...
#


# data structure templates

%config_settings = ("defined" => "yes");
%config_rooms = ();

# the star of the show

sub load_configuration
{

if (!open (CONFIGFILE, "bluelava.conf"))
{
	html_errormsg("Error Opening Configuration File", "The BlueLava configuration file, bluelava.conf, could not be opened."); 	
	exit(0);
}

local ($linenum) = 0;
local ($currentroom) = "";
local ($trashbin, $result);

local (@phrases) = ("bluelava_home", "bluelava_html", "bluelava_baseurl", 
"backend", "bottlerocket_path", "heyu_path", "ppower_path","x10d_host",
 "x10d_service", "flipit_path", "wish_path", "dim_units", 
"table_use_gradient", "table_gradient_start", "table_gradient_colorchange", 
"default_row_color", "table_gradient_colorop", "header_color_fg", 
"header_color_bg", "status_color_fg", "status_color_bg", "default_text_color",
"default_text_dimmed", "label_device_fg", "label_device_bg", "label_type_fg",
"label_type_bg", "label_actions_fg", "label_actions_bg");


while ( defined ($line = <CONFIGFILE>) )
{

    $linenum++; 

    # temporary fix -- will be removed when obscure tab bug found
    $line =~ s/\t/ /g;

    while ( ($line =~ /^[ \t]/) )
    {
	$trashbin = conf_stripchar(*line);	
    }

    if ( !($line =~ /^\n/) )
    {
	if ($line =~ /^[Rr][Oo][Oo][Mm] /)
	{
		$result = conf_entry_room(*currentroom, *line);
		
	}
	elsif ($line =~ /^[Dd][Ee][Vv][Ii][Cc][Ee] /)
	{
		$result = conf_entry_device(*currentroom, *line);
		if ( $currentroom eq "" )
		{
			html_errormsg("Error in Configuration File", "A device was defined without a room on line #$linenum.");
			exit(0);
		}
	

	}
	else
	{
	  if ( ! ( $line =~ /^[#\n]/ ) && !($line eq ""))
	  {
		$result = conf_entry_setting(*line);
	  }	
        }
    }


if ( (conf_thereismore(*line)) || ($result eq "ERROR") )
{
	html_errormsg("Error in Configuration File", "Syntax error found on line #$linenum of configuration file.");
	exit(0);
}
     
}

close (CONFIGFILE);

}

# the supporting casts

sub conf_entry_room
{
local (*currentroom, *line) = @_;
local (@roomlist);

$stringlength = length($line);
$line = substr($line, 4, ($stringlength-4));
        
$room = conf_extract(*line);

$config_rooms{$room} = \@roomlist;
$currentroom = \@roomlist;            

return($room);
}

sub conf_entry_device
{
local (*currentroom, *line) = @_;
local (@roomlist, %devicehash);

$stringlength = length($line);
$line = substr($line, 6, ($stringlength-6));

$devicehash{"id"} = conf_extract(*line);
$devicehash{"type"} = conf_extract(*line);
$devicehash{"name"} = conf_extract(*line);

@$currentroom = (@$currentroom, \%devicehash);

return($dev3);
}

sub conf_entry_setting
{
local (*line) = @_;

foreach $type (@phrases)
{
	if ($line =~ /^$type/)
	{
	$typelength = length($type);
	$line = substr($line, $typelength, ( length($line) - $typelength));

	$setting = conf_extract(*line);

	$config_settings{$type} = $setting;

	return ($setting);
        }
}

return("ERROR");
}
	
	  

sub conf_stripchar
{

local (*line) = @_;
local ($result);

$stringlength = length($line);
$result = substr($line, 0, 1);
$line = substr($line, 1, ($stringlength-1));

return ($result);

}

sub conf_thereismore
{

local (*line) = @_;
local ($trashbin);

while ( !($line =~ ~/^[\n#]/) || length($line) )
{
	$trashbin = conf_stripchar(*line);

	if ( ($trashbin eq "") || ($trashbin =~ /^[#\n]/ ))
	{
		return(0);
	}
	elsif ( !($trashbin =~ /^[ \n#\t]/ ))
	{
		return(1);
	} 

}

return(0);

} 


sub conf_extract  
{

# pointer to the scalar containing line
local (*line)= @_;
local ($stringlength, $result, $trashbin);

# strip leading spaces

while ( ( $line =~ /^[ \t]/ ) )
{
	$trashbin = conf_stripchar(*line);
}

# if there isn't a quotation mark then syntax is foobared (returns ERROR) 

if ( !($line =~ /^\"/) )
{
	return("ERROR");
}

# strip the leading quotation mark

$trashbin = conf_stripchar(*line);

# now get the text between quotation marks and add to $result

while ( !($line =~ /^\"/) )
{
	if ($line =~ /^\n/)
	{
		# opps... someone forgot a quotation mark!
		return("ERROR");
	}

	$result = $result . &conf_stripchar(*line);

}

# strip off ending quotation mark

$trashbin = conf_stripchar(*line);
		

# return what we stripped out of quotation marks, the modified line is
# returned via pointer

return ($result);

}


1;
